*****************************************************************************************************
***	Program name:  SFQ nutrient program.sas                                                                                 
*** Instructions: See sections labeled MACRO INSTRUCTIONS and MACRO STATEMENTS to set 
**  up the program for your data and computer
*** Date:  9/15/09 
*** Written by:  A. Steffen and L. Wilkens
*** Inputs:  Text data file entered in data entry layout and saved (with no period in the file name) as (Tab delimited) (*.txt) 
*** Outputs:  Permanent SAS file:  SURE.SFQNUT
***			  .csv file:  <filename>.csv (filename is name of text data file)
***			  Data entry error log:  <filename>.err  
******************************************************************************************************;

***************************************MACRO INSTRUCTIONS**************************************************
In the statements below beginning in %LET fill in the requested information after the "=" sign.  See examples below:
EXAMPLES
	*FILE LOCATION AND NAME:  	%LET INNAME = c:\SFQ\mydata.txt ;  	/*use backslash '\' between path levels & file name*/
	*ID FORMAT (character):  	%LET IDFORMAT = $ 	; 				/*Use dollar sign '$'*/
	*ID FORMAT (numeric):  		%LET IDFORMAT = 	;				/*leave blank*/ 
	*ID LENGTH (character):    	%LET IDLENGTH = $10.;  				/*Use dollar sign '$' before and period '.' after maximum length*/
	*ID LENGTH (numeric):		%LET IDLENGTH = best25.;			/*Use 'best' before and period '.' after maximum length*/
***************************************MACRO STATEMENTS*****************************************************;

%LET INNAME = 										;   /*FILE LOCATION AND NAME*/
%LET IDFORMAT = 									;	/*INDICATE CHARACTER ($) OR NUMERIC (blank)*/
%LET IDLENGTH =  			   						;	/*INDICATE LENGTH OF ID, SEE EXAMPLES ABOVE*/
*********************************************************************************************************************;
**No further edits are required for running this program, please save program and run;
**Check the log for errors.  If there are errors, revisit the above let statements and examples
*********************************************************************************************************************;
options mprint;
** Input file **;
data _null_;
  inname="&INNAME";
  lng=length(inname);
  found=0;
  do i=lng to 1 by -1;
    if substr(inname,i,1)='.' and found=0 then do;
      found=1;
      indx=i;
    end;
  end;
  errend="err";
  outend="csv";
  if found=1 then do;
    errname=substr(inname,1,indx) || errend;
    outname=substr(inname,1,indx) || outend;
  end;
  else do;
    errname=inname || errend;
    outname=inname || outend;
  end;
  call symput ('errname', errname);
  call symput ('outname', outname);
    slash=0;
  do i=lng to 1 by -1;
    if substr(inname,i,1)='\' and slash=0 then do;
      slash=1;
      slindx=i-1;
    end;
  end;
if slash=1 then	libloc=substr(inname,1,(slindx));
export=trim(libloc)||'\';
call symput('libloc', libloc);
call symput('export', export);
run;


libname SURE "&libloc";

data WORK.SFQ                                    ;
%let _EFIERR_ = 0; /* set the ERROR detection macro variable */
infile "&INNAME" delimiter='09'x MISSOVER  
DSD lrecl=32767 firstobs=2 ;
informat ID &IDLENGTH ;  
informat Supp_past_yr best32. ;
informat multi_F best32. ;
informat multi_Y best32. ;
informat Stress_F best32. ;
informat Stress_Y best32. ;
informat VitC_F best32. ;
informat VitC_Y best32. ;
informat VitE_F best32. ;
informat VitE_Y best32. ;
informat Folate_F best32. ;
informat Folate_Y best32. ;
informat VitB12_F best32. ;
informat VitB12_Y best32. ;
informat VitB6_F best32. ;
informat VitB6_Y best32. ;
informat Bone_F best32. ;
informat Bone_Y best32. ;
informat VitD_F best32. ;
informat VitD_Y best32. ;
informat Sele_F best32. ;
informat Sele_Y best32. ;
informat Iron_F best32. ;
informat Iron_Y best32. ;
informat Zinc_F best32. ;
informat Zinc_Y best32. ;
informat Fish_F best32. ;
informat Fish_Y best32. ;
informat Flax_F best32. ;
informat Flax_Y best32. ;
informat Garlic_F best32. ;
informat Garlic_Y best32. ;
informat Gluc_F best32. ;
informat Gluc_Y best32. ;
informat CoQ10_F best32. ;
informat CoQ10_Y best32. ;
informat Spalm_F best32. ;
informat Spalm_Y best32. ;
informat VitC_D best32. ;
informat VitE_D best32. ;
format ID &IDLENGTH ;   
format Supp_past_yr best12. ;
format multi_F best12. ;
format multi_Y best12. ;
format Stress_F best12. ;
format Stress_Y best12. ;
format VitC_F best12. ;
format VitC_Y best12. ;
format VitE_F best12. ;
format VitE_Y best12. ;
format Folate_F best12. ;
format Folate_Y best12. ;
format VitB12_F best12. ;
format VitB12_Y best12. ;
format VitB6_F best12. ;
format VitB6_Y best12. ;
format Bone_F best12. ;
format Bone_Y best12. ;
format VitD_F best12. ;
format VitD_Y best12. ;
format Sele_F best12. ;
format Sele_Y best12. ;
format Iron_F best12. ;
format Iron_Y best12. ;
format Zinc_F best12. ;
format Zinc_Y best12. ;
format Fish_F best12. ;
format Fish_Y best12. ;
format Flax_F best12. ;
format Flax_Y best12. ;
format Garlic_F best12. ;
format Garlic_Y best12. ;
format Gluc_F best12. ;
format Gluc_Y best12. ;
format CoQ10_F best12. ;
format CoQ10_Y best12. ;
format Spalm_F best12. ;
format Spalm_Y best12. ;
format VitC_D best12. ;
format VitE_D best12. ;
input
ID &IDFORMAT
Supp_past_yr
multi_F
multi_Y
Stress_F
Stress_Y
VitC_F
VitC_Y
VitE_F
VitE_Y
Folate_F
Folate_Y
VitB12_F
VitB12_Y
VitB6_F 
VitB6_Y 
Bone_F
Bone_Y
VitD_F
VitD_Y
Sele_F
Sele_Y
Iron_F
Iron_Y
Zinc_F
Zinc_Y
Fish_F
Fish_Y
Flax_F 
Flax_Y 
Garlic_F
Garlic_Y
Gluc_F 
Gluc_Y 
CoQ10_F 
CoQ10_Y 
Spalm_F 
Spalm_Y 
VitC_D
VitE_D
;
if _ERROR_ then call symputx('_EFIERR_',1);  /* set ERROR detection macro variable */
** Remove blank records **;
idf="&idformat";
if idf=' ' then do;
	if ID=. and multi_F=. and Stress_F=. and VitC_F=. and VitE_F=. and Folate_F=. and VitB12_F=. and VitB6_F=. and 
   	Bone_F=. and VitD_F=. and Sele_F=. and Iron_F=. and Zinc_F=. and Fish_F=. and Flax_F=. and Garlic_F=. and  
   	Gluc_F=. and CoQ10_F=. and Spalm_F=. then delete;
end;
if idf='$' then do;
	if ID=' ' and multi_F=. and Stress_F=. and VitC_F=. and VitE_F=. and Folate_F=. and VitB12_F=. and VitB6_F=. and 
   	Bone_F=. and VitD_F=. and Sele_F=. and Iron_F=. and Zinc_F=. and Fish_F=. and Flax_F=. and Garlic_F=. and  
   	Gluc_F=. and CoQ10_F=. and Spalm_F=. then delete;
end;
drop idf;
run;

** Error log for data entry related issues **;
data _null_;
  set sfq;
  file "&errname";
	if multi_F not in (.,1,2,3) then put 'Multivitamin frequency not in range ' id= multi_F=;
	if Stress_F not in (.,1,2,3) then put 'B-complex/Stress-tab type frequency not in range ' id= Stress_F=;
	if VitC_F not in (.,1,2,3) then put 'Vitamin C frequency not in range ' id= VitC_F=;
	if VitE_F not in (.,1,2,3) then put 'Vitamin E frequency not in range ' id= VitE_F=;
	if Folate_F not in (.,1,2,3) then put 'Folate frequency not in range ' id= Folate_F=;
	if VitB12_F not in (.,1,2,3) then put 'Vitamin B12 frequency not in range ' id= VitB12_F=;
	if VitB6_F  not in (.,1,2,3) then put 'Vitamin B6 frequency not in range ' id= VitB6_F =;
	if Bone_F not in (.,1,2,3) then put 'Calcium/Bone type frequency not in range ' id= Bone_F=;
	if VitD_F not in (.,1,2,3) then put 'Vitamin D  frequency not in range ' id= VitD_F=;
	if Sele_F not in (.,1,2,3) then put 'Selenium frequency not in range ' id= Sele_F=;
	if Iron_F not in (.,1,2,3) then put 'Iron frequency not in range ' id= Iron_F=;
	if Zinc_F not in (.,1,2,3) then put 'Zinc frequency not in range ' id= Zinc_F=;
	if Fish_F not in (.,1,2,3) then put 'Omega-3  frequency not in range ' id= Fish_F=;
	if Flax_F  not in (.,1,2,3) then put 'Flaxseed frequency not in range ' id= Flax_F =;
	if Garlic_F not in (.,1,2,3) then put 'Garlic frequency not in range ' id= Garlic_F=;
	if Gluc_F  not in (.,1,2,3) then put 'Glucosamine frequency not in range ' id= Gluc_F =;
	if CoQ10_F  not in (.,1,2,3) then put 'Coenzyme Q-10 frequency not in range ' id= CoQ10_F =;
	if Spalm_F  not in (.,1,2,3) then put 'Saw Palmetto frequency not in range ' id= Spalm_F =;
	if Supp_past_yr not in (.,1,2) then put 'Supplement use not in range ' id= Supp_past_yr=;
	if multi_Y not in (.,1,2,3,4) then put 'Multivitamin duration not in range ' id= multi_Y=;
	if Stress_Y not in (.,1,2,3,4) then put 'B-complex/Stress-tab type duration not in range ' id= Stress_Y=;
	if VitC_Y not in (.,1,2,3,4) then put 'Vitamin C duration not in range ' id= VitC_Y=;
	if VitE_Y not in (.,1,2,3,4) then put 'Vitamin E duration not in range ' id= VitE_Y=;
	if Folate_Y not in (.,1,2,3,4) then put 'Folate duration not in range ' id= Folate_Y=;
	if VitB12_Y not in (.,1,2,3,4) then put 'Vitamin B12 duration not in range ' id= VitB12_Y=;
	if VitB6_Y  not in (.,1,2,3,4) then put 'Vitamin B6 duration not in range ' id= VitB6_Y =;
	if Bone_Y not in (.,1,2,3,4) then put 'Calcium/Bone type duration not in range ' id= Bone_Y=;
	if VitD_Y not in (.,1,2,3,4) then put 'Vitamin D  duration not in range ' id= VitD_Y=;
	if Sele_Y not in (.,1,2,3,4) then put 'Selenium duration not in range ' id= Sele_Y=;
	if Iron_Y not in (.,1,2,3,4) then put 'Iron duration not in range ' id= Iron_Y=;
	if Zinc_Y not in (.,1,2,3,4) then put 'Zinc duration not in range ' id= Zinc_Y=;
	if Fish_Y not in (.,1,2,3,4) then put 'Omega-3  duration not in range ' id= Fish_Y=;
	if Flax_Y  not in (.,1,2,3,4) then put 'Flaxseed duration not in range ' id= Flax_Y =;
	if Garlic_Y not in (.,1,2,3,4) then put 'Garlic duration not in range ' id= Garlic_Y=;
	if Gluc_Y  not in (.,1,2,3,4) then put 'Glucosamine duration not in range ' id= Gluc_Y =;
	if CoQ10_Y  not in (.,1,2,3,4) then put 'Coenzyme Q-10 duration not in range ' id= CoQ10_Y =;
	if Spalm_Y  not in (.,1,2,3,4) then put 'Saw Palmetto duration not in range ' id= Spalm_Y =;
	if VitC_D not in (.,1,2,3,4) then put 'Vitamin C dose not in range ' id= VitC_D=;
	if VitE_D not in (.,1,2,3,4) then put 'Vitamin E dose not in range ' id= VitE_D=;
  run;

**Prepare nutrient calculations;
proc sort data=sfq;
  by id;
  run;

data freq (keep=ID multi_F Stress_F VitC_F VitE_F Folate_F VitB12_F VitB6_F Bone_F VitD_F Sele_F Iron_F Zinc_F Fish_F Flax_F Garlic_F 
	 Gluc_F CoQ10_F Spalm_F) 
     dose (keep=ID VitC_D VitE_D);
  set SFQ;
  run;

proc transpose data=freq name=VAR prefix=FREQ out=TF;
  by id;
  run;

data Tfreq ;
  set TF;
    VAR=scan(VAR,1,'_');
  run;

proc sort data=tfreq; 
  by ID var; 
  run;

proc transpose data=dose name=VAR prefix=Dose out=TD;
  by id;
  run;

data Tdose ;
  set TD;
	VAR=scan(VAR,1,'_');
run;

proc sort data=tdose; 
  by id var; 
  run;

data Tdata;
  merge tfreq tdose;
  	by id var;
	if freq1=. then amount=0;
	else if freq1=1 then amount=2/7;
	else if freq1=2 then amount=5/7;
	else if freq1=3 then amount=1;
  run;

proc sort data=tdata; 
  by var; 
  run;

Data Nutrients;
input VAR $ nut_1-nut_42 ;
datalines;
multi 609 30 150 200 72 0 120 0 2 680 0 0 0 0 150 0 250 300 100 2 75 20 5 10 48 80 745.5 1.7 0 20 2 0 1.5 10 897.75 25 3 60 400 20.25 10 15
Stress 0 45 0 0 0 0 0 0 0 680 0 0 0 0 0 0 0 0 0 0 0 50 0 20 0 0 0 20 0 0 0 0 50 0 0 32 5 150 0 0 0 0
VitC 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 500 0 0 0 0
VitE 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 180 0 0
Folate 0 0 0 0 0 0 0 0 0 680 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
VitB12 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 500 0 0 0 0 0 0
VitB6 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 100 0 0 0 0 0
Bone 0 0 0 500 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 200 0 0 0
VitD 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 400 0 0 0
Sele 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 200 0 0 0 0 0 0 0 0 0 0 0 0
Iron 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 65 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
Zinc 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 50
Fish 0 0 0 0 0 0 0 0 0 0 1000 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
Flax 0 0 0 0 0 0 0 0 0 0 0 1000 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
Garlic 0 0 0 0 0 0 0 0 0 0 0 0 500 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
Gluc 0 0 0 0 0 400 0 0 0 0 0 0 0 500 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 24 0 0 0 0 0 0 0 0 0 0
CoQ10 0 0 0 0 0 0 0 50 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0
Spalm 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 160 0 0 0 0 0 0 0 0 0 0 0 0 0
;
run;

proc sort data=nutrients; 
  by var; 
  run;

data nutappend ; 
  merge tdata nutrients;
 	by var;
  run;
data nutcalc;   /*This data set will allow one to see the amount per nutrient per supplement type*/
  set nutappend;
	if VAR='VitC' and dose1 ne . then do;
		if dose1=1 then nut_38=250;
		else if dose1=2 then nut_38=500;
		else if dose1 in(3,4) then nut_38=1000;
	end;
	if VAR='VitE' and dose1 ne . then do;
		if dose1=1 then nut_40=180;
		else if dose1=2 then nut_40=270;
		else if dose1=3 then nut_40=450;
		else if dose1=4 then nut_40=1000; 
	end;
	array nut(42) nut_1-nut_42;
        do i=1 to 42;
           nut(i)=nut(i)*amount;
        end;
run;

proc sort data=nutcalc; 
  by id; 
  run;

proc means data=nutcalc noprint;
  	var nut_1-nut_42;
  	by id;
  	output out=totnut (drop=_freq_ _type_) sum= ;
  run;

**Merge Raw responses with total nutrients, label and format;
Proc format ;
	value yn 1='Yes' 2='No';
	value freq 1='1 to 3 times/wk' 2='4 to 6 times/wk' 3='Once a day';
	value yr 1='1 yr or less' 2='2 to 4 years' 3='5 to 9 years' 4='10 years or more';
	value cdose 1='250 mg or less' 2='300 to 500 mg' 3='600 to 1000 mg' 4='More than 1000 mg';
	value edose 1='200 IU or less' 2='250 to 400 IU' 3='450 to 1000 IU' 4='More than 1000 IU';
run;

**Create permanent SAS file with labels & formats for original questions and appended nutrient values;
data SURE.SFQnut;
  merge sfq totnut;
	by id;
	label 
	id='Participant ID'
	Supp_past_yr='Did you take any dietary supplements during the past year, at least once a week?'
	multi_F='Regular One-a-Day, Centrum, or Theratype: Freq of use'
	Stress_F='B-Complex or Stress-tab type: Freq of use'
	VitC_F='Vitamin C: Freq of use'
	VitE_F='Vitamin E: Freq of use'
	Folate_F='Folic acid, folate: Freq of use'
	VitB12_F='Vitamin B-12: Freq of use'
	VitB6_F='Vitamin B-6: Freq of use'
	Bone_F='Calcium, alone or combined with something else such as in a bone health supplement OR antacid: Freq of use'
	VitD_F='Vitamin D alone: Freq of use'
	Sele_F='Selenium: Freq of use'
	Iron_F='Iron: Freq of use'
	Zinc_F='Zinc: Freq of use'
	Fish_F='Fish oil or omega-3 fatty acids: Freq of use'
	Flax_F='Flaxseed: Freq of use'
	Garlic_F='Garlic, as a pill, tablet or capsule: Freq of use'
	Gluc_F='Glucosamine, alone or combined with something else: Freq of use'
	CoQ10_F='Coenzyme Q-10: Freq of use'
	Spalm_F='Saw Palmetto: Freq of use'
	multi_Y='Regular One-a-Day, Centrum, or Theratype: Duration of use'
	Stress_Y='B-Complex or Stress-tab type: Duration of use'
	VitC_Y='Vitamin C: Duration of use'
	VitE_Y='Vitamin E: Duration of use'
	Folate_Y='Folic acid, folate: Duration of use'
	VitB12_Y='Vitamin B-12: Duration of use'
	VitB6_Y='Vitamin B-6: Duration of use'
	Bone_Y='Calcium, alone or combined with something else such as in a bone health supplement OR antacid: Duration of use'
	VitD_Y='Vitamin D alone: Duration of use'
	Sele_Y='Selenium: Duration of use'
	Iron_Y='Iron: Duration of use'
	Zinc_Y='Zinc: Duration of use'
	Fish_Y='Fish oil or omega-3 fatty acids: Duration of use'
	Flax_Y='Flaxseed: Duration of use'
	Garlic_Y='Garlic, as a pill, tablet or capsule: Duration of use'
	Gluc_Y='Glucosamine, alone or combined with something else: Duration of use'
	CoQ10_Y='Coenzyme Q-10: Duration of use'
	Spalm_Y='Saw Palmetto: Duration of use'
	VitC_D='When you took Vitamin C, how much did you usually take?'
	VitE_D='When you took Vitamin E, how much did you usually take?'
	nut_1='Beta-Carotene (mcg)'
	nut_2='Biotin (mcg)'
	nut_3='Boron (mcg)'
	nut_4='Calcium (mg)'
	nut_5='Chloride (mg)'
	nut_6='Chondroitin (mg)'
	nut_7='Chromium (mcg)'
	nut_8='Coenzyme Q-10 (mg)'
	nut_9='Copper (mg)'
	nut_10='Dietary Folate Equivalents from supplements (mcg)'
	nut_11='Fish Oil (mg)'
	nut_12='Flax Seed Oil (mg)'
	nut_13='Garlic (mg)'
	nut_14='Glucosamine (mg)'
	nut_15='Iodine (mcg)'
	nut_16='Iron (mg)'
	nut_17='Lutein (mcg)'
	nut_18='Lycopene (mcg)'
	nut_19='Magnesium (mg)'
	nut_20='Manganese (mg)'
	nut_21='Molybdenum (mcg)'
	nut_22='Niacin (mg)'
	nut_23='Nickel (mcg)'
	nut_24='Pantothenic Acid (mg)'
	nut_25='Phosphorus (mg)'
	nut_26='Potassium (mg)'
	nut_27='Retinol (nutr 204 = mcg)'
	nut_28='Riboflavin (mg)'
	nut_29='Saw Palmetto (mg)'
	nut_30='Selenium (mcg)'
	nut_31='Silicon (mg)'
	nut_32='Sodium (mg)'
	nut_33='Thiamin (mg)'
	nut_34='Vanadium (mcg)'
	nut_35='Vitamin A (RAE) (mcg)'
	nut_36='Vitamin B-12 (mcg)'
	nut_37='Vitamin B-6 (mg)'
	nut_38='Vitamin C (mg)'
	nut_39='Vitamin D (IU)'
	nut_40='Vitamin E (Alpha Tocopherol in mg)'
	nut_41='Vitamin K (mcg)'
	nut_42='Zinc (mg)';
  run;

proc print data=sure.sfqnut noobs;
title 'Print of final file with formatted responses';
var id--nut_42;
format Supp_past_yr yn. multi_F Stress_F VitC_F VitE_F Folate_F VitB12_F VitB6_F Bone_F VitD_F Sele_F Iron_F Zinc_F Fish_F Flax_F Garlic_F 
	Gluc_F CoQ10_F Spalm_F freq. multi_Y Stress_Y VitC_Y VitE_Y Folate_Y VitB12_Y VitB6_Y Bone_Y VitD_Y Sele_Y Iron_Y Zinc_Y Fish_Y 
	Flax_Y Garlic_Y Gluc_Y CoQ10_Y Spalm_Y yr. VitC_D cdose. VitE_D edose.;
run;

**Output data set in .csv;
ods csv file="&outname";
ods listing close;
  proc print data=sure.sfqnut noobs;
  var id--nut_42;
  format Supp_past_yr -- vite_d 1.0;
    run;
ods csv close;


